/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.pathfinding;

import com.badlogic.gdx.ai.pfa.GraphPath;
import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalFailedException;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.FollowPathGoal;
import technology.rocketjump.undermount.entities.planning.PathfindingCallback;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class WaitForPathfindingGoal
extends Goal
implements PathfindingCallback {
    public static final float MAX_TIME_TO_WAIT = 5.0f;
    private final TiledMap map;
    private GraphPath<Vector2> path;
    private boolean parentGoalCreated;
    private float timeSpentWaiting = 0.0f;

    public WaitForPathfindingGoal(Entity parentEntity, Goal parentGoal, TiledMap map) {
        super(parentEntity, parentGoal);
        this.map = map;
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        if (this.path != null) {
            if (this.path.getCount() == 0) {
                throw new GoalFailedException("Could not find a valid path");
            }
            FollowPathGoal followPathGoal = new FollowPathGoal(this.parentEntity, this.parentGoal, this.path, this.map);
            this.parentGoal.getChildGoals().addLast(followPathGoal);
            this.parentGoalCreated = true;
        } else {
            this.timeSpentWaiting += deltaTimeSeconds;
            if (this.timeSpentWaiting > 5.0f) {
                throw new GoalFailedException("Pathfinding time exceeded, cancelling " + this.getClass().getSimpleName());
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.parentGoalCreated;
    }

    @Override
    public void pathfindingComplete(GraphPath<Vector2> path, long relatedId) {
        this.path = path;
    }
}

